/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.mediasvc.DeviceClassProperties;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameterKeys;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameters;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

abstract class MediaDeviceProperties
implements MediaServicesErrorIds,
MediaServicesParameterKeys {
    private static final String TRACE_MASKT = "XMDAMDPT";
    private static final String TRACE_MASKF = "XMDAMDPF";
    private static final String TRACE_MASKD = "XMDAMDPD";
    private DeviceClassProperties deviceClassProperties;
    private String deviceName;
    private LocalizableText displayableName;
    private LocalizableText displayableDescription;
    private boolean preferred;
    protected String mountPoint;
    protected String deviceFile;
    protected String deviceFileSymLink;
    MediaServicesParameters mediaServicesParameters;
    protected final String DEVICE_FILE_SCRIPT = "media.device.file.script";
    protected static final String FSTAB_FILE = "/etc/fstab";

    MediaDeviceProperties(DeviceClassProperties dcp) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.MediaDeviceProperties(DeviceClassProperties = " + dcp + ")");
        this.deviceClassProperties = dcp;
        this.preferred = false;
        this.mediaServicesParameters = MediaServicesParameters.getMediaServicesParameters();
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.MediaDeviceProperties()");
    }

    LocalizableText getDisplayableName() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDisplayableName(): returns " + this.displayableName);
        return this.displayableName;
    }

    void setDisplayableName(LocalizableText name) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.setDisplayableName(displayableName = " + name.toString() + ")");
        this.displayableName = name;
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.setDisplayableName()");
    }

    LocalizableText getDisplayableDescription() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDisplayableDescription(): returns " + this.displayableDescription);
        return this.displayableDescription;
    }

    void setDisplayableDescription(LocalizableText description) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.setDisplayableDescription(displayableDescription = " + description.toString() + ")");
        this.displayableDescription = description;
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.setDisplayableDescription()");
    }

    boolean isPreferred() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isPreferred(): returns " + this.preferred);
        return this.preferred;
    }

    void setPreferred(boolean b) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.setPreferred(" + b + ")");
        this.preferred = b;
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.setPreferred()");
    }

    String getDeviceName() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDeviceName(): returns " + this.deviceName);
        return this.deviceName;
    }

    void setDeviceName() {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.setDeviceName()");
        this.deviceName = this.mountPoint.substring(this.mountPoint.lastIndexOf("/") + 1);
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.setDeviceName()");
    }

    String getMountPoint() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getMountPoint(): returns " + this.mountPoint);
        return this.mountPoint;
    }

    abstract void setMountPoint(String var1);

    String getDeviceFile() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDeviceFile(): returns " + this.deviceFile);
        return this.deviceFile;
    }

    abstract void setDeviceFile(String var1) throws MediaDeviceException;

    String getDeviceFileSymLink() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDeviceFileSymLink(): returns " + this.deviceFileSymLink);
        return this.deviceFileSymLink;
    }

    int[] getMediaSupported() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getMediaSupported()");
        return this.deviceClassProperties.getMediaSupported();
    }

    int[] getFileSystems() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getFileSystems()");
        return this.deviceClassProperties.getFileSystems();
    }

    String getLabelScript() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getLabelScript(): returns " + this.deviceClassProperties.getLabelScript());
        return this.deviceClassProperties.getLabelScript();
    }

    String getDosDrive() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDosDrive(): returns " + this.deviceClassProperties.getDosDrive());
        return this.deviceClassProperties.getDosDrive();
    }

    String getDeviceType() {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.getDeviceType()");
        String deviceType = this.deviceClassProperties.getDeviceType();
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.getDeviceType(): returns " + deviceType);
        return deviceType;
    }

    boolean isEjectable() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isEjectable(): returns " + this.deviceClassProperties.isEjectable());
        return this.deviceClassProperties.isEjectable();
    }

    boolean isLockable() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isLockable(): returns " + this.deviceClassProperties.isLockable());
        return this.deviceClassProperties.isLockable();
    }

    boolean isFormattable() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isFormattable(): returns " + this.deviceClassProperties.isFormattable());
        return this.deviceClassProperties.isFormattable();
    }

    boolean isReadOnly() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isReadOnly(): returns " + this.deviceClassProperties.isReadOnly());
        return this.deviceClassProperties.isReadOnly();
    }

    boolean isMassWritable() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isMassWritable(): returns " + this.deviceClassProperties.isMassWritable());
        return this.deviceClassProperties.isMassWritable();
    }

    boolean isMassReadOnly() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isMassReadOnly(): returns " + this.deviceClassProperties.isMassReadOnly());
        return this.deviceClassProperties.isMassReadOnly();
    }

    boolean isMediaSupported(int mediaType) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.isMediaSupported(mediaType = " + mediaType + ")");
        boolean result = this.deviceClassProperties.isMediaSupported(mediaType);
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.isMediaSupported()");
        return result;
    }
}

